/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.core.zend.debugger.parameters;

import com.aptana.php.debug.epl.PHPDebugEPLPlugin;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org2.eclipse.php.debug.core.debugger.parameters.IWebDebugParametersInitializer;
import org2.eclipse.php.internal.debug.core.Logger;
import org2.eclipse.php.internal.debug.core.zend.debugger.parameters.AbstractDebugParametersInitializer;

public class DefaultDebugParametersInitializer
extends AbstractDebugParametersInitializer
implements IWebDebugParametersInitializer {
    @Override
    public Hashtable<String, String> getDebugParameters(ILaunch launch) {
        String sessID;
        ILaunchConfiguration launchConfiguration;
        String url;
        Hashtable<String, String> parameters = new Hashtable<String, String>();
        parameters.put("start_debug", "1");
        String port = launch.getAttribute("port");
        if (port != null) {
            parameters.put("debug_port", port);
        } else {
            PHPDebugEPLPlugin.logError("A port was not defined for the DefaultDebugParametersInitializer.");
        }
        if (this.getBooleanValue(launch.getAttribute("passiveDebug"))) {
            parameters.put("debug_passive", "1");
        }
        parameters.put("send_sess_end", "1");
        if (this.getBooleanValue(launch.getAttribute("webServerDebugger"))) {
            parameters.put("debug_host", PHPDebugEPLPlugin.getDebugHosts());
            parameters.put("debug_no_cache", Long.toString(System.currentTimeMillis()));
        }
        if ("debug".equals(launch.getLaunchMode()) && this.getBooleanValue(launch.getAttribute("firstLineBreakpoint"))) {
            parameters.put("debug_stop", "1");
        }
        if ((url = launch.getAttribute("uriginalURL")) != null) {
            parameters.put("original_url", url);
        }
        if ((launchConfiguration = launch.getLaunchConfiguration()) != null) {
            try {
                String sessionSetting = launchConfiguration.getAttribute("debugPages", "debugAllPages");
                if ("debugAllPages".equals(sessionSetting)) {
                    parameters.put("debug_start_session", "1");
                } else if ("debugFirstPage".equals(sessionSetting)) {
                    parameters.put("debug_new_session", "1");
                } else if ("debugFrom".equals(sessionSetting)) {
                    parameters.put("debug_start_url", launchConfiguration.getAttribute("debugContinue", ""));
                    if (launchConfiguration.getAttribute("debugFromURL", false)) {
                        parameters.put("debug_cont_session", "1");
                    }
                }
            }
            catch (CoreException ce) {
                Logger.logException(ce);
            }
        }
        if ((sessID = launch.getAttribute("debugSessionID")) != null) {
            parameters.put("debug_session_id", sessID);
        }
        return parameters;
    }

    @Override
    public URL getRequestURL(ILaunch launch) {
        String url = launch.getAttribute("uriginalURL");
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            Logger.logException("Malformed URL: " + url, e);
            return null;
        }
    }

    public boolean getBooleanValue(String value) {
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return false;
    }

    @Override
    public Hashtable<String, String> getRequestCookies(ILaunch launch) {
        return null;
    }

    @Override
    public Hashtable<String, String> getRequestHeaders(ILaunch launch) {
        return null;
    }

    @Override
    public String getRequestMethod(ILaunch launch) {
        return null;
    }

    @Override
    public Hashtable<String, String> getRequestParameters(ILaunch launch) {
        return null;
    }

    @Override
    public String getRequestRawData(ILaunch launch) {
        return null;
    }
}

